/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                           *** MSC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : DEMOFPV.C                                                */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demostrates how to use the AUXDRV.DRV driver to       */
/*       perform panning and fading effect on the playing voice.            */
/*                                                                          */
/*       You need to have a Sound Blaster Pro card to run this program.     */
/*                                                                          */
/*       Note that the BLASTER environment has to be set before executing   */
/*       this program.                                                      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include <sbc.h>
#include <sbcvoice.h>
#include <auxdrv.h>

#define   VOC_VOL   1

#include "loaddrv.c"

main ()
{
    extern  char far * near CTAuxDrv;
    extern  char far * near ctvdsk_drv;
    int     Handle;


    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 4)
        {
            if (sbc_test_int())
            {
                if (sbc_test_dma() >= 0)
                {
                    if (ctvdsk_drv = LoadDriver("CTVDSK.DRV"))
                    {
                        if (CTAuxDrv = LoadDriver("AUXDRV.DRV"))
                        {
                            if ( !ctvd_init(16) )
                            {
                                if ( Handle = GetFileHandle("DEMO1.VOC") )
                                {
                                    if ( OutputVoice(Handle) )
                                    {
                                        SoundEffect( ) ;
                                    }

                                    _dos_close (Handle) ;
                                }

                                ctvd_terminate() ;
                            }
                            else
                                ShowError() ;
                        }
                    }
                }
                else
                    printf("Error on DMA channel.\n");
            }
            else
                printf("Error on interrupt.\n");
        }
        else
            printf("Sound Blaster Card not found or wrong I/O settings.\n") ;
    }
    else
        printf("BLASTER environment not set or incomplete or invalid.\n");
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   SoundEffect (void)                                                     */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Add sound effect on the playback digitized sound.                  */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None                                                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None                                                               */
/*                                                                          */
/* ------------------------------------------------------------------------ */

SoundEffect (void)
{
    unsigned    wPrevVol;


    ctadInit( ) ;

    /* preserve the previous voice volume settings */
    wPrevVol = ctadGetVolume( VOC_VOL ) ;

    /* set voice left/right volume to 0 */
    ctadSetVolume( VOC_VOL, 0 ) ;

    /* Setup voice volume fading in mode 0 */
    ctadFade( VOC_VOL, 0xf0f0, 5000, 0, 0 ) ;
    ctadStartCtrl( ) ;
    WaitEffectEnd( ) ;


    /* Setup digitized sound for panning in mode 1  */
    /* repeat for 5 times                           */
    ctadPan( VOC_VOL, 0, 255, 600, 1, 5 ) ;
    ctadStartCtrl( ) ;
    WaitEffectEnd( ) ;


    /* set voice left/right volume to 0xf0f0 */
    ctadSetVolume( VOC_VOL, 0xf0f0 ) ;

    /* Setup voice volume fading in mode 0 */
    ctadFade( VOC_VOL, 0, 5000, 0, 0 ) ;
    ctadStartCtrl( ) ;
    WaitEffectEnd( ) ;


    /* set voice left/right volume back to previous status */
    ctadSetVolume( VOC_VOL, wPrevVol ) ;

    ctadTerminate( ) ;
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   WaitEffectEnd (void)                                                   */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Control the Fading and Panning effect of the digitized sound.      */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None                                                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None                                                               */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma loop_opt(off)   /* turn off loop optimiaztion */
WaitEffectEnd (void)
{
    /* End of sound effect process ? */
    while( CTFadeStatus || CTPanStatus )
    {
        /* Stop effect if no voice process */
        if ( !ct_voice_status )
            ctadStopCtrl();

        if ( _bios_keybrd(_KEYBRD_READY) )
        {
            switch ( _bios_keybrd(_KEYBRD_READ) & 0xff )
            {
                case 0x1b :
                    ctadStopCtrl( ) ;
                    ctvd_stop( ) ;
                    break ;

                case 'P' :
                case 'p' :
                    ctadPauseCtrl( ) ;
                    ctvd_pause( ) ;
                    break ;

                case 'C' :
                case 'c' :
                    ctadStartCtrl( ) ;
                    ctvd_continue( ) ;
                    break ;
            }
        }
    }
}
#pragma loop_opt()


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   GetFileHandle(char *szFilename)                                        */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Get a file handle with the filename specified.                     */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFilename :- filename to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       File handle if successful, else return 0.                          */
/*                                                                          */
/* ------------------------------------------------------------------------ */

GetFileHandle (char *szFilename)
{
    int     Handle ;


    /* Open and play the voice file */
    if ( _dos_open(szFilename, O_RDONLY, &Handle) )
    {
        Handle = 0;
        printf ( "Open %s file error\n", szFilename ) ;
    }

    return (Handle);
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   OutputVoice (int Handle)                                               */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Output voice with the file handle specified.                       */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       Handle : handle of a file to be outputted.                         */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Non-zero if successful, else return 0.                             */
/*                                                                          */
/* ------------------------------------------------------------------------ */

OutputVoice (int Handle)
{
    int     OutOK = 1;


    ctvd_speaker(1) ;

    if ( ctvd_output(Handle) != NO_ERROR )
    {
        OutOK = 0;
        ShowError () ;
    }


    return (OutOK);
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   ShowError (void)                                                       */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Display error occurred during the process of voice I/O.            */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

ShowError (void)
{
    int     Err ;


    /* Show the driver error and the DOS extended error code */
    Err = ctvd_drv_error() ;

    printf("Driver error = %2d\n", Err) ;

    Err = ctvd_ext_error();
    if ( Err )
        printf ("DOS error = %2d\n", Err) ;
}
